/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.storage.adapter.database;

import com.cobblemon.mod.common.api.storage.PokemonStore;
import com.cobblemon.mod.common.api.storage.StorePosition;
import com.cobblemon.mod.common.api.storage.adapter.CobblemonAdapterParent;
import com.cobblemon.mod.common.api.storage.adapter.flatfile.FileStoreAdapter;
import com.cobblemon.mod.common.api.storage.adapter.flatfile.JSONStoreAdapter;
import com.cobblemon.mod.common.api.storage.adapter.flatfile.NBTStoreAdapter;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.storage.pc.PCStore;
import com.cobblemon.mod.common.util.DistributionUtilsKt;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.ReplaceOptions;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_5218;
import net.minecraft.class_5455;
import net.minecraft.server.MinecraftServer;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ9\u0010\u0011\u001a\u00020\u0002\"\b\b\u0000\u0010\u000b*\u00020\n\"\u000e\b\u0001\u0010\r*\b\u0012\u0004\u0012\u00028\u00000\f2\u0006\u0010\u000e\u001a\u00028\u00012\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J3\u0010\u0019\u001a\u00020\u00182\u0012\u0010\u0014\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\f0\u00132\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJI\u0010\u001b\u001a\u0004\u0018\u00018\u0001\"\b\b\u0000\u0010\u000b*\u00020\n\"\u000e\b\u0001\u0010\r*\b\u0012\u0004\u0012\u00028\u00000\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00010\u00132\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001e\u001a\u00020\u001dH\u0014\u00a2\u0006\u0004\b\u001e\u0010\u001fJ)\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0 2\u0012\u0010\u0014\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\f0\u0013H\u0014\u00a2\u0006\u0004\b\"\u0010#R\u001a\u0010\u0005\u001a\u00020\u00048\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010$\u001a\u0004\b%\u0010&R\u001a\u0010\u0007\u001a\u00020\u00068\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010'\u001a\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020\u001d8\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b*\u0010+\u001a\u0004\b,\u0010\u001f\u00a8\u0006-"}, d2={"Lcom/cobblemon/mod/common/api/storage/adapter/database/MongoDBStoreAdapter;", "Lcom/cobblemon/mod/common/api/storage/adapter/CobblemonAdapterParent;", "Lcom/google/gson/JsonObject;", "Lcom/cobblemon/mod/common/api/storage/adapter/flatfile/FileStoreAdapter;", "Lcom/mongodb/client/MongoClient;", "mongoClient", "", "databaseName", "<init>", "(Lcom/mongodb/client/MongoClient;Ljava/lang/String;)V", "Lcom/cobblemon/mod/common/api/storage/StorePosition;", "E", "Lcom/cobblemon/mod/common/api/storage/PokemonStore;", "T", "store", "Lnet/minecraft/class_5455;", "registryAccess", "serialize", "(Lcom/cobblemon/mod/common/api/storage/PokemonStore;Lnet/minecraft/class_5455;)Lcom/google/gson/JsonObject;", "Ljava/lang/Class;", "storeClass", "Ljava/util/UUID;", "uuid", "serialized", "", "save", "(Ljava/lang/Class;Ljava/util/UUID;Lcom/google/gson/JsonObject;)V", "provide", "(Ljava/lang/Class;Ljava/util/UUID;Lnet/minecraft/class_5455;)Lcom/cobblemon/mod/common/api/storage/PokemonStore;", "Lcom/google/gson/Gson;", "createGson", "()Lcom/google/gson/Gson;", "Lcom/mongodb/client/MongoCollection;", "Lorg/bson/Document;", "getCollection", "(Ljava/lang/Class;)Lcom/mongodb/client/MongoCollection;", "Lcom/mongodb/client/MongoClient;", "getMongoClient", "()Lcom/mongodb/client/MongoClient;", "Ljava/lang/String;", "getDatabaseName", "()Ljava/lang/String;", "gson", "Lcom/google/gson/Gson;", "getGson", "common"})
public class MongoDBStoreAdapter
extends CobblemonAdapterParent<JsonObject>
implements FileStoreAdapter<JsonObject> {
    @NotNull
    private final MongoClient mongoClient;
    @NotNull
    private final String databaseName;
    @NotNull
    private final Gson gson;

    public MongoDBStoreAdapter(@NotNull MongoClient mongoClient, @NotNull String databaseName) {
        Intrinsics.checkNotNullParameter((Object)mongoClient, (String)"mongoClient");
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        this.mongoClient = mongoClient;
        this.databaseName = databaseName;
        this.gson = this.createGson();
    }

    @NotNull
    protected final MongoClient getMongoClient() {
        return this.mongoClient;
    }

    @NotNull
    protected final String getDatabaseName() {
        return this.databaseName;
    }

    @NotNull
    protected final Gson getGson() {
        return this.gson;
    }

    @Override
    @NotNull
    public <E extends StorePosition, T extends PokemonStore<E>> JsonObject serialize(@NotNull T store, @NotNull class_5455 registryAccess) {
        Intrinsics.checkNotNullParameter(store, (String)"store");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        return store.saveToJSON(new JsonObject(), registryAccess);
    }

    @Override
    public void save(@NotNull Class<? extends PokemonStore<?>> storeClass, @NotNull UUID uuid, @NotNull JsonObject serialized) {
        Intrinsics.checkNotNullParameter(storeClass, (String)"storeClass");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)serialized, (String)"serialized");
        Document document = Document.parse((String)this.gson.toJson((JsonElement)serialized));
        Intrinsics.checkNotNull((Object)document);
        ((Map)document).put("uuid", uuid.toString());
        ((Map)document).put("lastUpdated", new Date());
        MongoCollection<Document> collection = this.getCollection(storeClass);
        Document filter = new Document("uuid", (Object)uuid.toString());
        collection.replaceOne((Bson)filter, (Object)document, new ReplaceOptions().upsert(true));
    }

    @Override
    @Nullable
    public <E extends StorePosition, T extends PokemonStore<E>> T provide(@NotNull Class<T> storeClass, @NotNull UUID uuid, @NotNull class_5455 registryAccess) {
        Intrinsics.checkNotNullParameter(storeClass, (String)"storeClass");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        MinecraftServer minecraftServer = DistributionUtilsKt.server();
        Intrinsics.checkNotNull((Object)minecraftServer);
        MinecraftServer server = minecraftServer;
        File pokemonStoreRoot = server.method_27050(class_5218.field_24188).resolve("pokemon").toFile();
        String string = pokemonStoreRoot.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        JSONStoreAdapter jsonAdapter = new JSONStoreAdapter(string, true, true, null, 8, null);
        String string2 = pokemonStoreRoot.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
        NBTStoreAdapter nbtAdapter = new NBTStoreAdapter(string2, true, true);
        MongoCollection<Document> collection = this.getCollection(storeClass);
        Document filter = new Document("uuid", (Object)uuid.toString());
        Document document = (Document)collection.find((Bson)filter).first();
        if (document != null) {
            Object object;
            JsonObject json = (JsonObject)this.gson.fromJson(document.toJson(), JsonObject.class);
            try {
                object = new Class[]{UUID.class, UUID.class};
                Constructor<T> constructor = storeClass.getConstructor((Class<?>[])object);
                object = new Object[]{uuid, uuid};
                object = (PokemonStore)constructor.newInstance(object);
            }
            catch (NoSuchMethodException exception) {
                Object[] objectArray = new Class[]{UUID.class};
                Constructor<T> constructor = storeClass.getConstructor((Class<?>[])objectArray);
                objectArray = new Object[]{uuid};
                object = (PokemonStore)constructor.newInstance(objectArray);
            }
            Object[] store = object;
            Intrinsics.checkNotNull((Object)json);
            store.loadFromJSON(json, registryAccess);
            return (T)store;
        }
        T nbtStore = nbtAdapter.provide(storeClass, uuid, registryAccess);
        if (nbtStore != null) {
            this.save(storeClass, uuid, this.serialize(nbtStore, registryAccess));
            return nbtStore;
        }
        T jsonStore = jsonAdapter.provide(storeClass, uuid, registryAccess);
        if (jsonStore != null) {
            this.save(storeClass, uuid, this.serialize(jsonStore, registryAccess));
            return jsonStore;
        }
        return null;
    }

    @NotNull
    protected Gson createGson() {
        return new Gson();
    }

    @NotNull
    protected MongoCollection<Document> getCollection(@NotNull Class<? extends PokemonStore<?>> storeClass) {
        Intrinsics.checkNotNullParameter(storeClass, (String)"storeClass");
        Class<? extends PokemonStore<?>> clazz = storeClass;
        String collectionName = Intrinsics.areEqual(clazz, PlayerPartyStore.class) ? "PlayerPartyCollection" : (Intrinsics.areEqual(clazz, PCStore.class) ? "PCCollection" : "OtherCollection");
        MongoCollection mongoCollection = this.mongoClient.getDatabase(this.databaseName).getCollection(collectionName);
        Intrinsics.checkNotNullExpressionValue((Object)mongoCollection, (String)"getCollection(...)");
        return mongoCollection;
    }
}

